import sys
sys.path = ['C:/Users/Administrator/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path

from suds.client import Client
import datetime
from pytz import timezone
from pytz import common_timezones
import pytz
import time
from ReplaceDatabase import ReplaceDatabase
from time import sleep

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'ALABAMA'
state_short = 'AL'
domain = 'AL.VA.GOV'
facility1_site_id = '557'
facility2_abbr = 'AVARMC'
facility3_abbr = 'AVAOPC'
PatientSSN = '300000000'
patientLName = 'GREER'
PatientFullName='GREER,JUANA'

SeactionName = 'PRIMARY CARE'
AppointmentTypeCat = 'REGULAR'
ProviderResource = 'case1 step 9 test'
patientLName1 = 'HOGAN'
PatientFullName1 = 'HOGAN,LONNIE'
PatientSSN1 = '300000001'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase6Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase6/cache.dat")
sleep(60)

print 'setp 2 select an appointment to cancel'
PatientName = client.service.SearchPatients(facility1_site_id,PatientSSN)
#print PatientName

for p in PatientName.PatientSearchResult:
	if p.LastName == patientLName:
		PatientN = p
		break;

pat = client.service.GetPatient(PatientN)		
#print pat.Id

facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)

for p in facilities.Facility:
	if p.Name == facility3:
		facility3_id = p.Id
		break;

sec = client.service.GetSections(facility3_id)
#print sec
for  p in sec.Section:
	 if p.Name==SeactionName:
		SectionN = p
		break;



res = client.service.GetAllResourcesOfType(SectionN.Id,'Provider')

for p in res.Resource:
	if p.Name==ProviderResource:
		resprov=p
		break;


#------------------------Policies and Slots------------------------------------------------------		
schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '3'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resprov.SchedulingPolicies = schPolicies


RSlots = client.factory.create('ns0:ArrayOfSlot')
RSlot = client.factory.create('ns0:Slot')
RSlot.Time = 'PT17H'
RSlot.Length = 15
RSlot.Capacity = 1
RSlot.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot)
#---
RSlot2 = client.factory.create('ns0:Slot')
RSlot2.Time = 'PT17H15M'
RSlot2.Length = 15
RSlot2.Capacity = 1
RSlot2.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot2)
schPolicy.Slots = RSlots
#---
RSlot2 = client.factory.create('ns0:Slot')
RSlot2.Time = 'PT17H30M'
RSlot2.Length = 15
RSlot2.Capacity = 1
RSlot2.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot2)
schPolicy.Slots = RSlots
#----
RSlot3 = client.factory.create('ns0:Slot')
RSlot3.Time = 'PT17H45M'
RSlot3.Length = 15
RSlot3.Capacity = 1
RSlot3.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot3)
schPolicy.Slots = RSlots
#----
RSlot3 = client.factory.create('ns0:Slot')
RSlot3.Time = 'PT18H'
RSlot3.Length = 15
RSlot3.Capacity = 2
RSlot3.AppointmentType = SectionN.AppointmentTypes.AppointmentType[0]
RSlots.Slot.append(RSlot3)
schPolicy.Slots = RSlots
Result = client.service.UpdateResource(resprov)

#print RSlots
#-----------------------------------------------------------------------------------------
		
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = SectionN
appTimeStamp = datetime.datetime(2013,05,22,19,00,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

MakeAppt = client.service.CreateAppointment(appointment)
#print MakeAppt

SchedTime = MakeAppt.Time
AptID = MakeAppt.Id
#print AptID		
		
#raw_input()

AppTimeFrom = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day)
AppTimeTo = datetime.datetime(appTimeStamp.year,appTimeStamp.month+1,appTimeStamp.day)
#print AppTimeFrom, AppTimeTo, pat.Id

TheAppoint = client.service.GetAppointmentsForPatient(pat.Id,AppTimeFrom,AppTimeTo)
for p in TheAppoint.Appointment:
	if p.Id==AptID:
		TheTime=p
		break;


CanApptR = client.service.GetCancellationReasons(facility1_site_id) 



CanHold = CanApptR.CancellationReason[0].VistaId

print 'Step 3 Appointment Cancellation:' + '\n'

CanAppt = client.service.CancelAppointment(TheTime.Id,'PC',CanHold,'Will Schedule Later')

print 'Appointment Id:', TheTime.Id, ' has been cancelled' +'\n'

print 'Step 4 Reason for Cancellation:' + '\n'
print CanApptR.CancellationReason[0] 

print 'checkpoint 1'
if logdetail == 1:
	print CanApptR
print 'verified appointment is cancelled with reason'

print 'Step 5 Review the associated appointments'+'\n'
appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = SectionN
appTimeStamp = datetime.datetime(2013,05,22,19,15,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
appointment.HighPriorityReschedule='1'

MakeAppt = client.service.CreateAppointment(appointment)

HighPr = MakeAppt.HighPriorityReschedule 
HighId = MakeAppt.Id



appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resprov

appointment.Patient = pat
appointment.Length = 15
appointment.Section = SectionN
appTimeStamp = datetime.datetime(2013,05,22,19,30,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

MakeAppt1 = client.service.CreateAppointment(appointment)

relation = client.factory.create('ns0:AppointmentRelation')
ARelation = client.factory.create('ns0:ArrayOfAppointmentRelation')
relation.ChildAppointment = MakeAppt1
relation.RelationType='Followup'
ARelation.AppointmentRelation = relation
MakeAppt.ChildAppointments = ARelation

RelResults = client.service.UpdateAppointment(MakeAppt)
#print RelResults

ATimeFrom = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day)
ATimeTo = datetime.datetime(appTimeStamp.year,appTimeStamp.month+1,appTimeStamp.day)

Asso = client.service.GetAppointmentsForPatient(pat.Id,ATimeFrom,ATimeTo)
for p in Asso.Appointment:
	if p.Id==MakeAppt1.Id:
		AChild=p
		break;
print 'Step 6 Cancel Associated Appointment' + '\n'

CanApptR1 = client.service.GetCancellationReasons(facility1_site_id) 
CanHold1 = CanApptR1.CancellationReason[0].VistaId

CanAppt1 = client.service.CancelAppointment(AChild.Id,'PC',CanHold1,'Will Schedule Later')
print 'Associated Appointment Id:', AChild.Id, ' has been cancelled' +'\n'

print 'checkpoint 2'
if logdetail == 1:
	print CanAppt1
print 'verified cancellation of associated appointment'

print 'Step 7 High Priority'+'\n'
HTimeFrom = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day)
HTimeTo = datetime.datetime(appTimeStamp.year,appTimeStamp.month+1,appTimeStamp.day)

HighP = client.service.GetAppointmentsForPatient(pat.Id,HTimeFrom,HTimeTo)
for p in HighP.Appointment:
	if p.Id==HighId:
		if p.HighPriorityReschedule==True:
			HPr=p
			break;
#print HPr
#print HPr.HighPriorityReschedule

print 'Step 8 Add Patient to Rescheduling List'+'\n'
appointment.Patient = pat
appointment.Length = 15
appointment.Section = SectionN
appTimeStamp = datetime.datetime(2013,05,22,19,45,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

HighAppt = client.service.CreateAppointment(appointment)
#print HighAppt 


Que = client.factory.create('ns0:CommunicationQueueItem')

Que.Recipient = pat.Id
Que.SendBy = datetime.datetime(2013,5,23)
Que.SentOn = datetime.datetime(2013,5,22)
Que.Subject = 'Appointment/Cancel/Re-Schedule'
Que.Body = 'Cancel/Re-Sechdule'
Que.Appointment = HighAppt

QAdd = client.service.AddToCommunicationQueue(Que)


Que1 = client.service.GetAllRelatedCommunications(HighAppt)
print 'Step 9 Cancellation/Reschedule notification'+'\n'
#print Que1

print 'checkpoint 3'
if logdetail == 1:
	print HighAppt
	print Que1
print 'verified cancellation/reschedule notification'

#print 'Group Appointment'+'\n'

appointment.Patient = pat
appointment.Length = 15
appointment.Section = SectionN
appTimeStamp = datetime.datetime(2013,05,22,20,00,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

GroupApt = client.service.CreateAppointment(appointment)


#print 'Second Patient'+'\n'

PatientName1 = client.service.SearchPatients(facility1_site_id,PatientSSN1)
#print PatientName

for p in PatientName1.PatientSearchResult:
	if p.LastName == patientLName1:
		Patient1 = p
		break;

pat1 = client.service.GetPatient(Patient1)	

appointment.Patient = pat1
appointment.Length = 15
appointment.Section = SectionN
appTimeStamp = datetime.datetime(2013,05,22,20,00,00) #datetime.datetime.utcnow()
appTimeStamp = appTimeStamp.replace(tzinfo=pytz.utc)
appTimeStamp = appTimeStamp.replace(microsecond=0)
if time.localtime().tm_isdst==1:
	appointment.Time = appTimeStamp+datetime.timedelta(hours=-1) 
appointment.Resources = resourcearray		
appointment.AppointmentType=SectionN.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'

GroupApt1 =  client.service.CreateAppointment(appointment)
#print GroupApt1

print 'Step 10 Cancel Ind. Group Appt for Patient ID:', pat1.Id, '\n'

ATimeFrom2 = datetime.datetime(appTimeStamp.year,appTimeStamp.month,appTimeStamp.day)
ATimeTo2 = datetime.datetime(appTimeStamp.year,appTimeStamp.month+1,appTimeStamp.day)

grp = client.service.GetAppointmentsForPatient(pat1.Id,ATimeFrom2,ATimeTo2)
for p in grp.Appointment:
	if p.Id==GroupApt1.Id:
		grpD=p
		break;

CanR = client.service.GetCancellationReasons(facility1_site_id) 
CanR1 = CanR.CancellationReason[1].VistaId
sleep(10)
CanApptG = client.service.CancelAppointment(grpD.Id,'C',CanR1,'Individual Cancel')

print 'checkpoint 4'
if logdetail == 1:
	print CanApptG
print 'Individual Group Appointment Id:', grpD.Id, ' has been cancelled' +'\n'

print 'Step 11 Cancel Group Appt'+'\n'
grp1 = client.service.GetAppointmentsForPatient(pat.Id,ATimeFrom2,ATimeTo2)
for p in grp1.Appointment:
	if p.Id==GroupApt.Id:
		grpD1=p
		break;

CanR1 = client.service.GetCancellationReasons(facility1_site_id) 
CanR2 = CanR1.CancellationReason[0].VistaId

CanApptG1 = client.service.CancelAppointment(grpD1.Id,'PC',CanR2,'Group Cancel')

print 'checkpoint 5'
if logdetail == 1:
	print CanApptG1
print 'Group Appointment Id:', grpD1.Id, ' has been cancelled' +'\n'
